%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 9.4
% File: cond_mean.m
% Coded by: Dawit Zerom
%
% Computing conditional MEAN forecasts. 
%
% Reference:
% De Gooijer, J.G. and Zerom, D. (2000).
%    Kernel based multi-step-ahead prediction of the U.S. short-term 
%    interest rate. Journal of Forecasting, 19(4), 335-353.
%    DOI: 10.1002/1099-131x(200007)19:4\%3C335::aid-for777\%3E3.3.co;2-v
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load    = waiting.dat;
datan   = waiting;
[nr,nc] = size(datan);
data1   = datan; 
k       = 1;    % Maximum Markov order
mx      = 10;   % Maximum forecast horizon   
x1      = data1(k:nr);
data    = x1;
z       = data;
n2      = 289;     % Start data set Geyser-waiting time
n3      = 289;     % End data set 
df      = n3-n2+1; 
n       = n2;
while n<=n3 
    m = 1;
    while m<= mx 
       n0   = n-m;
       y    = z(m+1:n,1);
       x0   = z(1:n0);
       sd   = std(data1(1:n));
       hop  = (sd)*((n)^(-1/(k+4)));  % Optimal bandwidth
       sum1 = 0;
       sum2 = 0;
       for t1 = 1:n0
         vect1 = (z(n)-x0(t1))/hop;
         xx    = vect1*vect1';
         %  Gaussian kernel
         sum1  = sum1+(exp(-0.5*xx))*((2*pi)^(-k/2));
         vect2 = (y(t1)*(exp(-0.5*xx))*((2*pi)^(-k/2)));
         sum2  = sum2+vect2;
       end
       if(sum1 == 0)
         sum1 = 1.0e-300;
       end
       ztmean(n,m) = sum2/sum1; % mth-step ahead forecast (until mx)                                     % made at time t=n=n2
       dif(n,m)    = data1(n+m,1)- ztmean(n,m);
       m           = m+1; 
   end         
   n = n+1;    
end 
dif_mean    = dif(n2:n3,1:mx);             % Resize matrix
MSFE_mean   = sum(dif_mean*dif_mean')/mx;        
RMAFE_mean  = (100/mx)*sum(abs(dif_mean)'./abs(data1(n2+1:nr,1)));
